# 선인장
다른 식물들처럼, [선인장](objects/cactus)도 흙에서 키우고 평소처럼 수확할 수 있어요.

하지만, 선인장은 다양한 크기로 자라며 이상한 순서 감각을 가지고 있어요.

다 자란 선인장을 수확할 때 모든 이웃 선인장이 정렬된 순서라면, 모든 이웃 선인장도 재귀적으로 수확해요.

`North`와 `East` 방향의 모든 이웃 선인장이 다 자랐고 크기가 같거나 더 크고, `South`와 `West` 방향의 모든 이웃 선인장이 다 자랐고 크기가 같거나 더 작으면, 그 선인장은 정렬된 것으로 간주돼요.

수확은 모든 인접한 선인장이 다 자랐고 정렬된 순서일 경우에만 퍼져나가요.
즉, 다 자란 선인장 사각형이 크기 순으로 정렬되어 있고 그중 하나를 수확하면, 사각형 전체가 수확된다는 뜻이에요.

다 자란 선인장은 정렬되지 않았으면 갈색으로 보여요. 정렬되면 다시 녹색으로 변해요.

수확한 선인장 개수의 제곱만큼 선인장을 받게 돼요. 따라서 `n`개의 선인장을 동시에 수확하면 `n**2`개의 `Items.Cactus`를 받게 돼요.

선인장의 크기는 `measure()`로 측정할 수 있어요.
크기는 항상 `0,1,2,3,4,5,6,7,8,9` 중 하나예요.

`measure(direction)`에 방향을 전달하여 드론의 해당 방향에 있는 이웃 타일을 측정할 수도 있어요.

`swap()` 명령을 사용하여 어떤 방향으로든 이웃한 선인장과 위치를 바꿀 수 있어요.
`swap(direction)`은 드론 아래의 객체와 드론의 `direction` 방향으로 한 칸 떨어진 객체를 교환해요.

## 예시
다음 각 격자에서 모든 선인장은 정렬된 순서이며 수확은 밭 전체로 퍼져나가요:
`3 4 5    3 3 3    1 2 3    1 5 9
2 3 4    2 2 2    1 2 3    1 3 8
1 2 3    1 1 1    1 2 3    1 3 4`

이 격자에서는 왼쪽 아래 선인장만 정렬된 순서이며, 이는 수확이 퍼져나가기에 충분하지 않아요:
`1 5 3
4 9 7
3 3 2`

<spoiler=힌트 1 보기>
행이 이미 정렬되어 있다면, 열을 정렬해도 행의 정렬이 풀리지 않아요.
</spoiler>
<spoiler=힌트 2 보기>
정렬 알고리즘에 익숙하지 않다면, 온라인에서 찾아보고 어떤 것이 이 문제에 적용될 수 있을지 생각해보세요. 이웃한 선인장만 교환할 수 있기 때문에 모든 알고리즘이 작동하는 것은 아니라는 점을 명심하세요.
</spoiler>